/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.MenuItemStyle;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import de.javasoft.util.java2d.Synthetica2DUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class MenuStyle
extends StyleWrapper {
    private static MenuStyle instance = new MenuStyle();

    private MenuStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        jComponent.setOpaque(false);
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        MenuStyle menuStyle = new MenuStyle();
        menuStyle.setStyle(synthStyle);
        return menuStyle;
    }

    public Font getFont(SynthContext synthContext) {
        MenuItemStyle.menuItemHtmlColorCorrection(synthContext);
        Font font = this.synthStyle.getFont(synthContext);
        JMenu jMenu = (JMenu)synthContext.getComponent();
        Object object = SyntheticaLookAndFeel.get("Synthetica.menu.toplevel.fontSize", jMenu);
        if (object != null && jMenu.isTopLevelMenu()) {
            float f = SyntheticaLookAndFeel.scaleFontSize(new Float(object.toString()).floatValue());
            font = font.deriveFont(f);
        }
        return font;
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        boolean bl;
        JMenu jMenu = (JMenu)synthContext.getComponent();
        Boolean bl2 = (Boolean)jMenu.getClientProperty("Synthetica.MOUSE_OVER");
        boolean bl3 = bl2 == null ? false : bl2;
        boolean bl4 = (synthContext.getComponentState() & 0x200) > 0;
        boolean bl5 = bl = (synthContext.getComponentState() & 1) > 0;
        if (jMenu.isTopLevelMenu() && colorType.equals(ColorType.TEXT_FOREGROUND)) {
            String string = "Synthetica.menu.toplevel.textColor";
            Window window = SwingUtilities.getWindowAncestor(jMenu);
            if (!window.isActive() && SyntheticaLookAndFeel.getBoolean("Synthetica.window.decoration", window) && SyntheticaLookAndFeel.get(String.valueOf(string) + ".inactive", window) != null && !bl4 && !bl3) {
                string = String.valueOf(string) + ".inactive";
            } else if (!bl) {
                string = String.valueOf(string) + ".disabled";
            } else if (bl4 || bl3) {
                string = String.valueOf(string) + ".selected";
            }
            Color color = SyntheticaLookAndFeel.getColor(string, jMenu);
            if (color != null) {
                return color;
            }
        }
        return this.synthStyle.getColor(synthContext, colorType);
    }

    public Icon getIcon(SynthContext synthContext, Object object) {
        Icon icon = super.getIcon(synthContext, object);
        if ("Menu.arrowIcon".equals(object) && !synthContext.getComponent().getComponentOrientation().isLeftToRight()) {
            icon = new ImageIcon(Synthetica2DUtils.flipHorizontal(GraphicsUtils.iconToImage(synthContext, icon)));
        }
        return icon;
    }
}

